//
// Stretch example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//
// NOTE: this example does not work yet!
//

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Timer;
import ptc.Color;
import ptc.Format;
import ptc.Surface;
import ptc.Console;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.awt.image.ImageObserver;



class Stretch
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();

            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

            // open the console
            console.open("Stretch example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);

            // create image surface
            Surface image = new Surface(320,140,format);

            // load image to surface
            load(image,"Stretch.jpg");

            // setup stretching parameters
            final int x  = surface.width()  / 2;
            final int y  = surface.height() / 2;
            final int dx = surface.width()  / 2;
            final int dy = surface.height() / 3;

            // create timer
            Timer timer = new Timer();

            // start timer
            timer.start();

            // loop until a key is pressed
            while (!console.key())
            {
                // get current time from timer
                final double time = timer.time();

                // clear surface to white background
                surface.clear(new Color(1.0f,1.0f,1.0f));

                // calculate zoom factor at current time
                final float zoom = 2.5f * (float) ( 1.0 - Math.cos(time) );
            
                // calculate zoomed image coordinates
                final int x1 = (int) ( x - zoom * dx );
                final int y1 = (int) ( y - zoom * dy );
                final int x2 = (int) ( x + zoom * dx );
                final int y2 = (int) ( y + zoom * dy );

                // setup image copy area
                Area area = new Area(x1,y1,x2,y2);

                // copy and stretch image to surface
                image.copy(surface,image.area(),area);
    
                // copy surface to console
                surface.copy(console);

                // update console
                console.update();
            }
        }
        catch (Error error)
        {
            // report error
            error.report();
        }

        // exit program
        System.exit(0);
    }

    public static void load(Surface surface,String filename) throws Error
    {
        // get default awt toolkit
        Toolkit toolkit = Toolkit.getDefaultToolkit();

        // load image
        java.awt.Image image = toolkit.getImage(filename);

        // lock surface
        int pixels[] = (int[]) surface.lock();

        // create image grabber
        PixelGrabber pg = new PixelGrabber(image,0,0,surface.width(),surface.height(),pixels,0,surface.width());
        
        try 
        {
            // grab pixels
         pg.grabPixels();
        } 
        catch (InterruptedException e) 
        {
            // error message
            throw new Error("interrupted during image load");
        }

        // check if pixel grab succeeded
        if ((pg.getStatus() & ImageObserver.ABORT) != 0) throw new Error("failed to load image");

        // unlock surface
        surface.unlock();
    }
}
