//
// Buffer example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Error;
import ptc.Format;
import ptc.Palette;
import ptc.Console;



class Buffer
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
            // open the console
            console.open("Buffer example",format);

            // get console dimensions
            final int width  = console.width();
            final int height = console.height();

            // allocate a buffer of pixels
            int pixels[] = new int[width*height];

            // loop until a key is pressed
            while (!console.key())
            {
                // draw random pixels
                for (int i=0; i<100; i++)
                {
                    // get random position
                    final int x = random(width);
                    final int y = random(height);

                    // get random color
                    final int r = random(256);
                    final int g = random(256);
                    final int b = random(256);

                    // draw color [r,g,b] at position [x,y]
                    pixels[x+y*width] = (r<<16) + (g<<8) + b;
                }
        
                // load pixels to console
                console.load(pixels,width,height,width*4,format,new Palette());
            
                // update console
                console.update();
            }
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
        
        // exit program
        System.exit(0);
    }

    static int random(int number)
    {
        // random number routine
        return (int) ( Math.random() * number );
    }
}
