//
// Surface class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_SURFACE_H
#define __PTC_SURFACE_H

// include files
#include "Base.h"




class Surface : public BaseSurface
{
    public:

        // constructors and destructors
        Surface(int width,int height,Format& format);
        virtual ~Surface();

        // copy
        virtual void copy(BaseSurface &surface);

        // memory
        virtual void* lock();
        virtual void unlock();

        // palette
        virtual void palette(int32 palette[]);

        // access
        virtual int width();
        virtual int height();
        virtual int pitch();
        virtual const Format& format();

    private:

        // data
        int m_width;
        int m_height;
        void *m_pixels;
        Format m_format;
        int32 m_palette[256];
};




#endif
