//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_COPY_H
#define __PTC_COPY_H

// include files
#include "ptconfig.h"
#include "Format.h"




class Copy
{
    public:

        // setup
        Copy();
        Copy(const Format &source,const Format &destination);
        ~Copy();

        // set pixel formats
        void formats(const Format &source,const Format &destination);

        // set source palette
        void palette(int32 palette[]);

        // copy pixels
        void copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,int s_pitch,
                  void *d_pixels,int d_x,int d_y,int d_width,int d_height,int d_pitch);

    protected:

        // copy conversion
        static void convert_copy(Copy &copy,void *source,void *destination,unsigned count);

        // direct color to direct color conversion
        static void convert_direct32_direct32_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct24_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct16_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct8_rgba(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct32_rgb(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct24_rgb(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct16_rgb(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_direct32_direct8_rgb(Copy &copy,void *source,void *destination,unsigned count);

        // indexed color to direct color conversion
        static void convert_indexed8_direct32(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_indexed8_direct24(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_indexed8_direct16(Copy &copy,void *source,void *destination,unsigned count);
        static void convert_indexed8_direct8(Copy &copy,void *source,void *destination,unsigned count);

    private:

        // convert function type
        typedef void (*Function)(Copy &copy,void *source,void *destination,unsigned count);

        // utility functions
        int32 topbit(int32 mask);
        void setup(const Format &source,const Format &destination);
        Copy::Function Copy::function(const Format &source,const Format &destination);

        // field data
        struct Field
        {
            int32 mask;
            int shift;
        };

        // format information
        struct Information
        {
            Field r;
            Field g;
            Field b;
            Field a;
        };

        // palette data        
        void *table;
        int32 buffer[256];
        
        // format data
        Format s_format;
        Format d_format;
        
        // conversion data
        int s_bytes;
        int d_bytes;
        Information info;
        Function convert;
        Function generate;
};




#endif
