//
// Random example: draws random pixels
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"




int main()
{
    try
    {
        // create format
        Format format(32,0x00FF0000,0x0000FF00,0x000000FF);

        // create console
        Console console("Random example",320,200,format);

        // create surface
        Surface surface(320,200,format);
        
        // loop until a key is pressed
        while (!console.key())
        {
            // lock surface
            int32 *pixels = (int32*) surface.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(320);
                int y = random(200);

                // get random color
                int r = random(256);
                int g = random(256);
                int b = random(256);

                // draw color [r,g,b] at position [x,y]
                pixels[x+y*320] = (r<<16) + (g<<8) + b;
            }
        
            // unlock surface
            surface.unlock();

            // copy to console
            surface.copy(console);

            // update console
            console.update();
        }

        // done
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
