//
// Win32 Hook class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_WIN32_HOOK_H
#define __PTC_WIN32_HOOK_H

// include files
#include <windows.h>
#include "Core/Config.h"
#include "Win32/Monitor.h"




class Win32Hook
{
    public:

        // setup
        Win32Hook(HWND window,DWORD thread);
        ~Win32Hook();

    protected:

        // window procedure
        virtual LRESULT WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam) = 0;

    private:

        // keyboard message hook
        static LRESULT CALLBACK hook(int code,WPARAM wParam,LPARAM lParam);

        // lookup structure
        struct Lookup
        {
            HWND handle;
            Win32Hook *hook[256];
        };
        
        // hook data
        HHOOK m_handle;

        // static data
        static Win32Monitor m_monitor;
        static Lookup m_registry[256];
};




#endif
