//
// Win32 Hook class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Win32/Hook.h"

// static member data
Win32Monitor Win32Hook::m_monitor;
Win32Hook::Lookup Win32Hook::m_registry[256];




Win32Hook::Win32Hook(HWND window,DWORD thread)
{
    // set window hook
    m_handle = SetWindowsHookEx(WH_GETMESSAGE,(HOOKPROC)hook,GetModuleHandle(0),thread);

    // check window hook handle
    if (!m_handle) throw Error("could not set window hook");

    // add to registry
    m_monitor.enter();
    m_registry[0].hook[0] = this;
    m_registry[0].handle = window;
    m_monitor.leave();
}


Win32Hook::~Win32Hook()
{
    // remove from registry
    m_monitor.enter();
    m_registry[0].hook[0] = 0;
    m_registry[0].handle = 0;
    m_monitor.leave();

    // free window hook
    UnhookWindowsHookEx(m_handle);
}




LRESULT CALLBACK Win32Hook::hook(int code,WPARAM wParam,LPARAM lParam)
{
    // get message data
    MSG *message = (MSG*)lParam;

    // enter monitor
    m_monitor.enter();

    // lookup hook pointers for hWnd
    Lookup &lookup = m_registry[0];

    // leave monitor
    m_monitor.leave();

    // check lookup
    if (lookup.hook)
    {
        // call user window procedure
        if (code==HC_ACTION) lookup.hook[0]->WndProc(message->hwnd,message->message,message->wParam,message->lParam);
    
        // call next hook
        return CallNextHookEx(lookup.hook[0]->m_handle,code,wParam,lParam);
    }
    else
    {
        // finished
        return 0;
    }
}
