//
// Mode class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_MODE_H
#define __PTC_MODE_H

// include files
#include "Core/Types.h"
#include "Core/Format.h"
#include "Core/Config.h"




class Mode
{
    public:

        // setup
        DLLAPI PTCAPI Mode();
        DLLAPI PTCAPI Mode(int width,int height,const Format &format);
        DLLAPI PTCAPI Mode(const Mode &mode);
        DLLAPI PTCAPI ~Mode();

        // valid mode flag
        DLLAPI bool PTCAPI valid() const;

        // data access
        DLLAPI int PTCAPI width() const;
        DLLAPI int PTCAPI height() const;
        DLLAPI const Format& PTCAPI format() const;

        // operators
        DLLAPI Mode& PTCAPI operator =(const Mode &mode);
        DLLAPI bool PTCAPI operator ==(const Mode &mode) const;
        DLLAPI bool PTCAPI operator !=(const Mode &mode) const;

    private:

        // debug check
        void check() const;

        // data
        bool m_valid;
        int m_width;
        int m_height;
        Format m_format;
};




#endif
