//
// Win32 Window class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_WIN32_WINDOW_H
#define __PTC_WIN32_WINDOW_H

// include files
#include <windows.h>
#include "Win32/Index.h"




namespace ptc
{
    namespace Win32
    {
        class Window
        {
            public:

                // setup
                Window(HWND window);
                Window(const char wndclass[],const char title[],unsigned extra,unsigned style,int show,int x,int y,int width,int height,bool cursor,bool multithreaded,void *data=0);
                ~Window();
        
                // update window
                void update();

                // data access
                HWND handle();
                DWORD thread();
                bool multithreaded();

            private:

                // internals
                void defaults();
                void close();

                // window internals
                static void WINAPI ThreadFunction(Window *owner);
                static LRESULT CALLBACK WndProcSingleThreaded(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
                static LRESULT CALLBACK WndProcMultiThreaded(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);
        
                // window data
                HWND m_window;
                HCURSOR m_cursor;
                HANDLE m_event;
                HANDLE m_thread;
                DWORD m_id;

                // window creation data
                char m_name[1024];    // window class name
                char m_title[1024];   // window title
                unsigned m_extra;     // window style extra
                unsigned m_style;     // window style
                int m_show;           // window show command
                int m_x;              // window x
                int m_y;              // window y
                int m_width;          // window width
                int m_height;         // window height
                void *m_data;         // creation data

                // multithread flag
                bool m_multithreaded;
        };
    }
}




#endif
