//
// Win32 Keyboard class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_WIN32_KEYBOARD_H
#define __PTC_WIN32_KEYBOARD_H

// include files
#include "Win32/Hook.h"
#include "Win32/Event.h"
#include "Win32/Window.h"
#include "Win32/Monitor.h"




namespace ptc
{
    namespace Win32
    {
        class Keyboard : public Hook
        {
            public:
        
                // setup
                Keyboard(HWND window,DWORD thread,bool multithreaded);
                ~Keyboard();

                // input
                bool key();
                int read(Window &window);

            private:

                // window procedure
                virtual LRESULT WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

                // data
                bool m_key;
                bool m_multithreaded;
                Event m_event;
                Monitor m_monitor;

                // key buffer
                int m_index;
                int m_buffer[1024];
        };
    }
}




#endif
