//
// Win32 Hook class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "Win32/Hook.h"

// using directive
using namespace ptc::Win32;

// using declarations
using ptc::Core::Error;

// static member data
Monitor Hook::m_monitor;
List<Hook::Lookup> Hook::m_registry;




Hook::Hook(HWND window,DWORD thread)
{
    // set window hook
    m_handle = SetWindowsHookEx(WH_GETMESSAGE,(HOOKPROC)hook,GetModuleHandle(0),thread);

    // check window hook handle
    if (!m_handle) throw Error("could not set window hook");

    // add to registry
    m_monitor.enter();
    m_lookup = new Lookup;
    m_lookup->hook = this;
    m_lookup->handle = window;
    m_registry.add(m_lookup);
    m_monitor.leave();
}


Hook::~Hook()
{
    // remove from registry
    m_monitor.enter();
    m_registry.free(m_lookup);
    m_monitor.leave();

    // free window hook
    UnhookWindowsHookEx(m_handle);
}




LRESULT CALLBACK Hook::hook(int code,WPARAM wParam,LPARAM lParam)
{
    // get message data
    MSG *message = (MSG*)lParam;

    // enter monitor
    m_monitor.enter();

    // lookup "Hook" object from "hWnd"
    List<Lookup>::Iterator iterator = m_registry.first();
    Lookup *lookup = iterator.current();
    while (lookup && lookup->handle!=message->hwnd) lookup = iterator.next();

    // leave monitor
    m_monitor.leave();

    // check lookup
    if (lookup)
    {
        // call user window procedure
        if (code==HC_ACTION) lookup->hook->WndProc(message->hwnd,message->message,message->wParam,message->lParam);
    
        // call next hook
        return CallNextHookEx(lookup->hook->m_handle,code,wParam,lParam);
    }
    else
    {
        // finished
        return 0;
    }
}
