//
// Win32 Event class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Event.h"
#include "Core/Error.h"

// using directive
using namespace ptc::Win32;

// using declarations
using ptc::Core::Error;




Event::Event()
{
    // create event handle
    m_event = CreateEvent(0,TRUE,FALSE,0);

    // check event handle
    if (!m_event) throw Error("could not create event");
}


Event::~Event()
{
    // close handle
    CloseHandle(m_event);
}


void Event::set()
{
    // set event
    SetEvent(m_event);
}


void Event::reset()
{
    // reset event
    ResetEvent(m_event);
}


void Event::wait()
{
    // wait for event
    WaitForSingleObject(m_event,INFINITE);
}


HANDLE Event::handle()
{
    // get handle
    return m_event;
}
