//
// Header definitions for the MMX routines for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_HEAD_MMX__
#define __HERMES_HEAD_MMX__

// If you cannot stand ifdefs, then please do not look into this file, it's
// going to end your life :)

#ifndef NO_ASSEMBLER


#ifdef __cplusplus
extern "C" {
#endif

#if defined __GNUC__
void ConvertMMX(HermesInterface *) __attribute__ ((regparm(1)));
#else
void ConvertMMX(HermesInterface *);
#endif

int CheckMMX();

void ConvertMMX32_32RGB888();
void ConvertMMX32_16RGB565();
void ConvertMMX32_16RGB555();

#ifdef __cplusplus
}
#endif



// Fix the underscore business with ELF compilers

#if defined(__ELF__) && defined(__GNUC__)
  #ifdef __cplusplus 
  extern "C" {   
  #endif

  void ConvertMMX() __attribute__ ((alias ("_ConvertMMX"))) __attribute__ ((regparm(1)));
  int CheckMMX() __attribute__ ((alias ("_CheckMMX")));

  void ConvertMMX32_32RGB888() __attribute__ ((alias ("_ConvertMMX32_32RGB888")));
  void ConvertMMX32_16RGB565() __attribute__ ((alias ("_ConvertMMX32_16RGB565")));  
  void ConvertMMX32_16RGB555() __attribute__ ((alias ("_ConvertMMX32_16RGB555")));

  #ifdef __cplusplus
  }
  #endif

#endif // ELF and GNUC




// Make it work with Watcom
#ifdef __WATCOMC__
#pragma aux ConvertMMX "_*" parm [EAX] modify [EAX EBX ECX EDX ESI EDI]
#pragma aux CheckMMX "_*"
#pragma aux ConvertMMX32_32RGB888 "_*"
#pragma aux ConvertMMX32_16RGB565 "_*"
#pragma aux ConvertMMX32_16RGB555 "_*"
#endif // WATCOM

#endif // NO_ASSEMBLER


#endif
