//
// Primary class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_DIRECTX_PRIMARY_H
#define __PTC_DIRECTX_PRIMARY_H

// include files
#include <ddraw.h>
#include "Core/Copy.h"
#include "Core/Clear.h"
#include "Base/Types.h"
#include "Core/Format.h"
#include "Core/Palette.h"




namespace ptc
{
    namespace DirectX
    {
        class Primary
        {
            public:

                // setup
                Primary(HWND window,LPDIRECTDRAW ddraw,int pages,bool indexed,bool video,bool fullscreen);
                ~Primary();

                // synchronization
                void update();

                // copy to surface
                void copy(Base::Surface &surface);
                void copy(Base::Surface &surface,const Base::Area &source,const Base::Area &destination);

                // memory access
                void* lock();
                void unlock();

                // load pixels to primary
                void load(const void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                void load(const void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // save primary pixels
                void save(void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                void save(void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // clear primary pixels
                void clear(const Base::Color &color);
                void clear(const Base::Color &color,const Base::Area &area);

                // palette routines
                void palette(const Base::Palette &palette);
                const Base::Palette& palette() const;

                // access
                int width() const;
                int height() const;
                int pitch() const;
                const Base::Format& format() const;

            private:

                // pixel format translation
                Core::Format translate(DDPIXELFORMAT const &ddpf);

                // close
                void close();

                // data
                int m_pages;
                int m_width;
                int m_height;
                Core::Format m_format;

                // window
                HWND m_window;

                // fullscreen flag
                bool m_fullscreen;

                // objects
                Core::Copy m_copy;
                Core::Clear m_clear;
                Core::Palette m_palette;

                // directx interfaces
                LPDIRECTDRAW m_ddraw;
                LPDIRECTDRAWSURFACE m_back;
                LPDIRECTDRAWSURFACE m_front;
                LPDIRECTDRAWPALETTE m_ddpal;
                
                // surface interface array
                LPDIRECTDRAWSURFACE *m_surface;
        };
    }
}




#endif
