//
// DirectX Hook class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "DirectX/Hook.h"
#include "DirectX/Display.h"
#include "DirectX/Console.h"

// using directive
using namespace ptc::DirectX;

// using declarations
using ptc::Core::Error;




Hook::Hook(Console &console,HWND window,DWORD thread) : ptc::Win32::Hook(window,thread)
{
    // setup display
    m_console = &console;
}

    


LRESULT Hook::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message)
    {
        case WM_DIRECTX_OPEN:
        {
            // setup message data
            Display::Data *data = (Display::Data*)wParam;
            bool *result = (bool*)lParam;
            
            try
            {
                // open display
                data->display->open(hWnd,data->title,data->width,data->height,*data->format);

                // success
                *result = true;
            }
            catch (Error&)
            {
                // failure
                *result = false;
            }

            // set event
            data->event.set();
        }
        break;

        case WM_DIRECTX_CLOSE:
        {
            // setup message data
            Display::Data *data = (Display::Data*)wParam;

            try
            {
                // close display
                if (data->display) data->display->close();
            }
            catch (Error&)
            {
                // no exceptions thanks...
            }

            // set event
            data->event.set();
        }
        break;
    }

    // success
    return 0;
}
