//
// DirectX Display class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_DIRECTX_DISPLAY_H
#define __PTC_DIRECTX_DISPLAY_H

// include files
#include <ddraw.h>
#include <windows.h>
#include "Base/Format.h"
#include "Win32/Event.h"

// custom display messages
const WM_DIRECTX_OPEN  = WM_USER + 1;
const WM_DIRECTX_CLOSE = WM_USER + 2;




namespace ptc
{
    namespace DirectX
    {
        class Display
        {
            public:

                // constructor and destructor
                Display(LPDIRECTDRAW ddraw);
                ~Display();

                // display management
                void test(const char title[],int width,int height,const Base::Format &format);
                void open(HWND window);
                void open(HWND window,const char title[],int width,int height,const Base::Format &format);
                void close();

            public:

                // data structure
                struct Data
                {
                    Display *display;
                    const char *title;
                    int width;
                    int height;
                    const Base::Format *format;
                    Win32::Event event;
                };

            private:

                // data
                bool m_open;
                bool m_fullscreen;
                HWND m_window;
                LPDIRECTDRAW m_ddraw;
        };
    }
}




#endif
