//
// DirectX Display class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Core/Error.h"
#include "DirectX/Check.h"
#include "DirectX/Display.h"

// using directive
using namespace ptc::DirectX;

// using declarations
using ptc::Core::Error;




Display::Display(LPDIRECTDRAW ddraw)
{
    // setup data
    m_open = false;
    m_fullscreen = false;
    m_ddraw = ddraw;
    m_window = 0;
}


Display::~Display()
{
    // close
    close();
}




void Display::test(const char title[],int width,int height,const ptc::Base::Format &format)
{
    // test display mode
}


void Display::open(HWND window)
{
    // set window
    m_window = window;
                                                     
    // set normal cooperative level
    check(m_ddraw->SetCooperativeLevel(m_window,DDSCL_NORMAL));

    // update flags
    m_open = true;
    m_fullscreen = false;
}


void Display::open(HWND window,const char title[],int width,int height,const ptc::Base::Format &format)
{
    // set window
    m_window = window;

    // enter exclusive mode
    check(m_ddraw->SetCooperativeLevel(m_window,DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWMODEX));

    // set display mode
    switch (format.bits())
    {
        case 32: 
        {
            // set virtual 32bit mode
            if (m_ddraw->SetDisplayMode(width,height,32)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,24)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,16)==DD_OK) break;
            
            // error message
            throw Error("could not set virtual 32bit mode");
        }
        break;

        case 24:
        {
            // set virtual 24bit mode
            if (m_ddraw->SetDisplayMode(width,height,24)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,32)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,16)==DD_OK) break;

            // error message
            throw Error("could not set virtual 24bit mode");
        }
        break;

        case 16: 
        {
            // set virtual 16bit mode
            if (m_ddraw->SetDisplayMode(width,height,16)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,24)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,32)==DD_OK) break;

            // error message
            throw Error("could not set virtual 16bit mode");
        }
        break;

        case 8: 
        {
            // set virtual 8bit mode
            if (m_ddraw->SetDisplayMode(width,height,8)==DD_OK)  break;
            if (m_ddraw->SetDisplayMode(width,height,32)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,24)==DD_OK) break;
            if (m_ddraw->SetDisplayMode(width,height,16)==DD_OK) break;

            // error message
            throw Error("could not set virtual 8bit mode");
        }
        break;

        default:
        {
            // error message
            throw Error("unsupported pixel format");
        }
    }

    // update flags
    m_open = true;
    m_fullscreen = true;
}


void Display::close()
{
    // check if open
    if (m_open)
    {
        // check if fullscreen
        if (m_fullscreen)
        {
            // restore display mode
            m_ddraw->RestoreDisplayMode();
        
            // leave exclusive mode
            m_ddraw->SetCooperativeLevel(m_window,DDSCL_NORMAL);
        }
        
        // clear open flag
        m_open = false;
    }
}
