//
// DirectX Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_DIRECTX_CONSOLE_H
#define __PTC_DIRECTX_CONSOLE_H

// include files
#include "Base/Console.h"
#include "Win32/Window.h"
#include "Win32/Keyboard.h"
#include "DirectX/Hook.h"
#include "DirectX/Library.h"
#include "DirectX/Display.h"
#include "DirectX/Primary.h"




namespace ptc
{
    namespace DirectX
    {
        class Console : public Base::Console
        {
            public:

                // setup
                Console();
                ~Console();

                // console option string
                virtual bool option(const char string[]);

                // console management
                virtual void open(const char title[]);
                virtual void open(const char title[],const Base::Format &format);
                virtual void open(const char title[],int width,int height,const Base::Format &format);
                virtual void open(const char title[],int width,int height,const Base::Format &format,bool fullscreen);
                virtual void close();

                // synchronization
                virtual void update();
                virtual void update(const Base::Area &area);

                // keyboard input
                virtual bool key();
                virtual int read();

                // copy to surface
                virtual void copy(Base::Surface &surface);
                virtual void copy(Base::Surface &surface,const Base::Area &source,const Base::Area &destination);

                // memory access
                virtual void* lock();
                virtual void unlock();

                // load pixels to console
                virtual void load(const void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                virtual void load(const void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // save console pixels
                virtual void save(void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                virtual void save(void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // clear console
                virtual void clear(const Base::Color &color);
                virtual void clear(const Base::Color &color,const Base::Area &area);

                // set console palette
                virtual void palette(const Base::Palette &palette);
                virtual const Base::Palette& palette() const;

                // data access
                virtual int width() const;
                virtual int height() const;
                virtual int pitch() const;
                virtual const Base::Format& format() const;
                virtual const char* name() const;

            private:

                // disallow copy construction
                Console(const Console &other);

                // disallow console assignment
                Console& operator =(const Console &other);

                // console data
                bool m_fullscreen;

                // internal objects
                Win32::Hook *m_hook;
                Win32::Window *m_window;
                Win32::Keyboard *m_keyboard;
                DirectX::Library *m_library;
                DirectX::Display *m_display;
                DirectX::Primary *m_primary;

                // window data
                RECT m_rectangle;
                HWND m_foreground;

                // console option flags
                bool m_multithreaded_option;
        };
    }
}




#endif
