//
// Core Surface implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_SURFACE_H
#define __PTC_CORE_SURFACE_H

// include files
#include "Core/Copy.h"
#include "Core/Clear.h"
#include "Core/Palette.h"
#include "Base/Surface.h"




namespace ptc
{
    namespace Core
    {
        class Surface : Base::Surface
        {
            public:

                // setup
                Surface(int width,int height,const Base::Format &format);
                ~Surface();

                // copy to surface
                virtual void copy(Base::Surface &surface);
                virtual void copy(Base::Surface &surface,const Base::Area &source,const Base::Area &destination);

                // memory access
                virtual void* lock();
                virtual void unlock();

                // load pixels to surface
                virtual void load(const void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                virtual void load(const void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // save surface pixels
                virtual void save(void *pixels,int width,int height,const Base::Format &format,const Base::Palette &palette);
                virtual void save(void *pixels,int width,int height,const Base::Area &source,const Base::Area &destination,const Base::Format &format,const Base::Palette &palette);

                // clear surface
                virtual void clear(const Base::Color &color);
                virtual void clear(const Base::Color &color,const Base::Area &area);

                // surface palette
                virtual void palette(const Base::Palette &palette);
                virtual const Base::Palette& palette() const;
   
                // data access
                virtual int width() const;
                virtual int height() const;
                virtual int pitch() const;
                virtual const Base::Format& format() const;

            private:

                // disallow copy construction
                Surface(const Surface &other);

                // disallow surface assignment
                Surface& operator =(const Surface &other);

                // data
                int m_width;
                int m_height;
                Format m_format;
                bool m_locked;
                void *m_pixels;

                // objects
                Core::Copy m_copy;
                Core::Clear m_clear;
                Core::Palette m_palette;
        };
    }
}




#endif
