//
// Core Error implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_ERROR_H
#define __PTC_CORE_ERROR_H

// include files
#include "Base/Error.h"




namespace ptc
{
    namespace Core
    {
        class Error : public Base::Error
        {
            public:

                // setup
                Error();
                Error(const char message[]);
                Error(const ptc::Base::Error &other);
                ~Error();

                // rethrow error
                virtual void rethrow(const char message[]);

                // report error
                virtual void report() const;

                // get error message
                virtual const char* message() const;

                // operators
                Error& operator =(const Error &other);
                virtual Base::Error& operator =(const Base::Error &other);
                virtual bool operator ==(const Base::Error &other) const;
                virtual bool operator !=(const Base::Error &other) const;

            private:

                // defaults
                void defaults();
                
                // data
                char *m_message;
        };
    }
}




#endif
