//
// Core Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CORE_COPY_H
#define __PTC_CORE_COPY_H

// include files
#include "Base/Types.h"
#include "Base/Index.h"
#include "Hermes/Hermes.h"




namespace ptc
{
    namespace Core
    {
        class Copy
        {
            public:

                // setup
                Copy();
                ~Copy();

                // request conversion
                void request(const Base::Format &source,const Base::Format &destination);

                // set copy palettes
                void palette(const Base::Palette &source,const Base::Palette &destination);

                // copy pixels
                void copy(const void *s_pixels,int s_x,int s_y,int s_width,int s_height,int s_pitch,
                          void *d_pixels,int d_x,int d_y,int d_width,int d_height,int d_pitch);

            private:

                // translate to hermes format structure
                void translate(const Base::Format &source,HermesFormat *destination);

                // data
                int m_bytes;
        };
    }
}




#endif
