// TGA file handler
//
// Copyright (c) Glenn Fiedler 1999 (ptc@gaffer.org)
//
// Updated/bugfixed for Titan by Dan Brown (_danbrown_@yahoo.com)
//    please contact Dan Brown for any queries about this class
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//

#ifndef _TGA_HANDLER_H
#define _TGA_HANDLER_H

#include "ihandler.h"
#include <stdio.h>

class TGAHandler : public ImageHandler
{
public:

  // setup
  TGAHandler();
  TGAHandler(char *filename);
  virtual ~TGAHandler();

  // interface
  virtual int info(int32 &width,int32 &height,Format &format,int32 &palette);
  virtual int load(void *image, Palette *palette);
  virtual int save(char *filename, int32 width, int32 height, 
					     Format *format, Palette *palette, void *pixels, 
					     void *params);
  virtual int valid();
private:

  // sets default values
  void Defaults();

  // file stuff
  FILE *m_imagefile;
  char *m_filename;

  // tga header
  char8 m_header[18];

  // image data
  int32 m_width;
  int32 m_height;
  Format m_format;

  // does the image have a palette?
  char8 m_paletteflag;
};

#endif