// do a search and replace for <EXTENSION> replacing it with e.g. PCX
//
// <EXTENSION> file handler
//
// Copyright (c) 1999 name (email address)
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//


#include <memory.h>
#include "<lowercase EXTENSION>.h"
#include "error.h"

<EXTENSION>Handler::<EXTENSION>Handler()
{
    // defaults
    Defaults();    
}


<EXTENSION>Handler::<EXTENSION>Handler(char *filename)
{
    // defaults
    Defaults();

    m_filename = filename;

    // assign
    m_imagefile=fopen(m_filename, "rb+");
    if (m_imagefile == 0)
    {
      throw Error("Titan error - File does not exist");
    }

    // read <EXTENSION> header
    // INSERT CODE HERE

    fclose(m_imagefile);

    // setup width
    m_width= ;// INSERT CODE HERE

    // setup height
    m_height= ;// INSERT CODE HERE

    // setup format using bits per pixel
    switch () // INSERT CODE HERE
    {
        case 8:  m_format = Format(8); break;
        case 16: m_format = Format(16, 16<<10, 16<<5, 16);       break;
        case 24: m_format = Format(24, 0xff<<16, 0xff<<8, 0xff); break;
        case 32: m_format = Format(32, 0xff<<16, 0xff<<8, 0xff); break;
    }

    // setup palette flag
    m_paletteflag= ;// insert code here
}

<EXTENSION>Handler::~<EXTENSION>Handler()
{
    // avoid warnings
    if (m_imagefile);
}

int <EXTENSION>Handler::info(int32 &width,int32 &height,Format &format,int32 &palette)
{
    // setup info
    width=m_width;
    height=m_height;
    format=m_format;
    palette=m_paletteflag;
    return 1;
}


int <EXTENSION>Handler::load(void *image, Palette *palette)
{
    m_imagefile = fopen(m_filename, "rb+");

    // read palette
    if (palette && m_paletteflag)
    {
        // setup temp palette buffer
        char8 *temp=new char8[palette_length*palette_bits/8];
        if (!temp) throw(Error("Titan error - Could not allocate a palette"));

        // read palette into temp buffer
        // INSERT CODE HERE

        palette->load(temp);

        // deallocate memory
        delete temp;
    }

    // read image data
    if (image)
    {
      // INSERT CODE HERE
    }

    fclose(m_imagefile);

    // success
    return 1;
}


int <EXTENSION>Handler::save(int width,int height,Format &format, void *image,void *palette,char *options)
{
    // INSERT CODE HERE
    // if no save is defined, use this -
    throw Error("Titan error - <EXTENSION> save not available");
}


int <EXTENSION>Handler::valid()
{
  // INSERT VALIDATION CODE HERE
}




void <EXTENSION>Handler::Defaults()
{
    // defaults
    m_width=0;
    m_height=0;
    m_paletteflag=0;
    m_imagefile=NULL;
    memset(m_header,0,<SIZE OF HEADER>);
}
