// PNG file handler
//
// Copyright (c) 1999 Dan Brown (_danbrown_@yahoo.com)
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//
// This is a wrapper for libPNG

#ifndef _PNG_HANDLER_H
#define _PNG_HANDLER_H

#ifdef USE_PNG

#include <stdio.h>
#include <png.h>

#include "ihandler.h"

class PNGHandler : public ImageHandler
{
public:

  // setup
  PNGHandler();
  PNGHandler(char *filename);
  virtual ~PNGHandler();

  // interface
  virtual int info(int32 &width,int32 &height,Format &format,int32 &palette);
  virtual int load(void *image, Palette *palette);
  virtual int save(char *filename, int32 width, int32 height, 
					     Format *format, Palette *palette, void *pixels, 
					     void *params);
  virtual int valid();
private:

  // sets default values
  void Defaults();

  // file stuff
  FILE *m_imagefile;
  char *m_filename;

  // PNG header
  char8 m_header[8];

  // image data
  int32 m_width;
  int32 m_height;
  Format m_format;

  // does the image have a palette?
  int32 m_paletteflag;

  // Any file format specific variables
  png_structp png_ptr;             // PNG internal structure pointer
  png_infop info_ptr;              // PNG info pointer (size, bpp, etc)
  png_infop end_ptr;               // Don't know what this is used for?
};

#endif

#endif

