// PCX file handler
//
// Copyright (c) Dan Brown 1999 (_danbrown_@yahoo.com)
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//


#ifndef _PCX_HANDLER_H
#define _PCX_HANDLER_H

#ifdef USE_PCX

#include "ihandler.h"
#include <stdio.h>

class PCXHandler : public ImageHandler
{
    public:

        // setup
        PCXHandler();
        PCXHandler(char *filename);
        virtual ~PCXHandler();

        // interface
        virtual int info(int32 &width,int32 &height,Format &format,int32 &palette);
        virtual int load(void *image, Palette *palette);
        virtual int save(char *filename, int32 width, int32 height, 
					     Format *format, Palette *palette, void *pixels, 
					     void *params);
        virtual int valid();
    private:

        // defaults
        void Defaults();

        // file
        FILE *m_imagefile;
        char *m_filename;

        // pcx header
        char8 m_header[128];

        // image data
        int32 m_width;
        int32 m_height;
        int32 m_orienation;
        int32 m_paletteflag;
        Format m_format;

        // temporary stuff
        int m_temp;
};








#endif

#endif
