// Main Titan class
//
// Copyright (c) Dan Brown 1999 (_danbrown_@yahoo.com)
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//

#ifndef _IMAGE_H_
#define _IMAGE_H_

#include "ptc.h"
#include "ihandler.h"

class Image
{
public:
  Image(void);
  Image(char *filename);
  ~Image(void);

  void load(char *filename);
  void save(char *filename, int32 width, int32 height, Format *format, Palette *palette, void *pixels, int32 filetype, void *params);
  void save(char *filename, BaseSurface &surf, int32 filetype, void *params);
  void copy(BaseSurface &surf);
  void copy(BaseSurface &surf, const Area &src, const Area &dest);

  int32 width(void);
  int32 height(void);
  Format format(void);
  Palette palette(void);

private:
  void open(char *filename);

  void *m_pixels;
  ImageHandler *m_handler;
  int32 m_width;
  int32 m_height;
  Format m_format;
  int32 m_paletteflag;
  Palette m_palette;
};

#endif
