//
// Image loading example for the Titan 1.1.x image handling 
// library for PTC
// Copyright (c) Dan Brown (_danbrown_@yahoo.com)
// This source code is licensed under the GNU GPL
//

// include files
#include <stdio.h>
#include <conio.h>

#include "ptc"
#include "titan.h"
#include "defaults.h"

void main()
{
    try
    {
        // create console
        Console console;

        // create format
        Format format(32, 0xff<<16, 0xff<<8, 0xff);    // 32-bit
 
        // open the console
        console.open("View example for Titan", 320, 200, format);

        // create loader and load image (must be 320x200)
#ifdef __PTC_X11__
        Image *loader = new Image("../data/pcx24.pcx");
#else
        Image *loader = new Image("..\\data\\pcx24.pcx");
#endif

        // create surface matching image dimensions
        Surface surface(loader->width(),loader->height(),loader->format());

        // copy image to surface
        loader->copy(surface);

        // loader keeps a copy of the image, so get rid of it
        delete loader;

		// copy the surface to the console
		surface.copy(console);

        // update console
        console.update();

        // wait until a key is pressed
        console.read();
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
	printf("This is the view example for Titan version %s\n", TITANVERSIONSTRING);
}
