//
// Java Page class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Graphics;
import java.awt.Component;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;



public class Page implements ImageObserver
{
    public Page(int width,int height,Format format)
    {
        // create producer
        producer = new Producer(width,height,format);
        
        // create image using default toolkit
        image = Toolkit.getDefaultToolkit().createImage(producer);
    }

    public void close()
    {
        // flush image
        image.flush();
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // load pixels to image
        producer.load(pixels,width,height,pitch,format,palette);
    }
    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // load pixels to image
        producer.load(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // save image pixels
        producer.save(pixels,width,height,pitch,format,palette);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // save image area pixels
        producer.save(pixels,width,height,pitch,format,palette,source,destination);
    }

    public void clear(Color color,Area area) throws Error
    {
        // clear image area
    }

    public void draw(Graphics graphics,int x1,int y1,int x2,int y2)
    {        
        // check graphics
        if (graphics!=null)
        {
            // draw image to graphics context
            boolean result = graphics.drawImage(image,x1,y1,x2-x1,y2-y1,null);
        }
    }

    public void palette(Palette palette)
    {
        // set palette
        producer.palette(palette);
    }

    public boolean imageUpdate(Image image,int flags,int x,int y,int width,int height)
    {
        // image update
        return false;
    }

    // page data
    Image image;
    Producer producer;
}
