//
// Format class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package
package ptc;



public class Format implements Cloneable
{
    public Format()
    {
        // defaults
        bits = 0;
        r = 0;
        g = 0;
        b = 0;
        a = 0;
        direct = false;
        indexed = false;
    }

    public Format(int bits) throws Error
    {
        // check bits per pixel
        if (bits!=8) throw new Error("unsupported bits per pixel");

        // indexed color
        this.bits = bits;
        r = 0;
        g = 0;
        b = 0;
        a = 0;
        direct = false;
        indexed = true;
    }

    public Format(int bits,int r,int g,int b) throws Error
    {
        // check bits per pixel
        if (bits%8!=0 || bits<=0 || bits>32) throw new Error("unsupported bits per pixel");

        // direct color
        this.bits = bits;
        this.r = r;
        this.g = g;
        this.b = b;
        a = 0;
        direct = true;
        indexed = false;
    }

    public Format(int bits,int r,int g,int b,int a) throws Error
    {
        // check bits per pixel
        if (bits%8!=0 || bits<=0 || bits>32) throw new Error("unsupported bits per pixel");

        // direct color
        this.bits = bits;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        direct = true;
        indexed = false;
    }

    public int r()
    {
        // get r
        return r;
    }

    public int g()
    {
        // get g
        return g;
    }

    public int b()
    {
        // get b
        return b;
    }

    public int a()
    {
        // get a
        return a;
    }

    public int bits()
    {
        // get bits
        return bits;
    }

    public int bytes()
    {
        // get bytes
        return bits/8;
    }

    public boolean direct()
    {
        // get direct
        return direct;
    }

    public boolean indexed()
    {
        // get indexed
        return indexed;
    }

    public Format copy()
    {
        try
        {
            // clone format object
            return (Format) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    public boolean compare(Format format)
    {
        // check direct color
        if (direct && format.direct)
        {
            // check direct data
            if (r==format.r && g==format.g && b==format.b && a==format.a && bits==format.bits) return true;
            else return false;
        }
        else if (indexed && format.indexed)
        {
            // check indexed data
            if (bits==format.bits) return true;
            else return false;
        }
        else
        {
            // failure
            return false;
        }
    }

    // format data
    private int r;
    private int g;
    private int b;
    private int a;
    private int bits;
    private boolean direct;
    private boolean indexed;
}
