//
// Keyboard example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Key;
import ptc.Area;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Surface;
import ptc.Console;



class Keyboard
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
            // open the console
            console.open("Keyboard example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);
        
            // setup cursor data
            int x = surface.width() / 2;
            int y = surface.height() / 2;
            final int size = surface.width() / 10;
            final Color color = new Color(1.0f,1.0f,1.0f);

            // main loop
            while (true)
            {
                // check for key press
                while (console.key())
                {
                    // read console key press
                    final Key key = console.read();

                    // move slow
                    int delta = 1;

                    // shift modifier
                    if (key.shift())
                    {
                        // move fast
                        delta = 10;
                    }

                    // handle cursor keys
                    switch (key.code())
                    {
                        case Key.LEFT:  x-=delta; break;
                        case Key.RIGHT: x+=delta; break;
                        case Key.UP:    y-=delta; break;
                        case Key.DOWN:  y+=delta; break;
                    }

                    // exit when escape is pressed
                    if (key.code()==Key.ESCAPE) System.exit(0);
                }

                // clear surface
                surface.clear();

                // setup cursor area
                Area area = new Area(x-size,y-size,x+size,y+size);

                // draw cursor as a quad
                surface.clear(color,area);

                // copy to console
                surface.copy(console);
            
                // update console
                console.update();
            }
        }
        catch (Error error)
        {
            // report error
            error.report();
        }

        // exit program
        System.exit(0);
    }
}
