#ifndef PTC_CONVERTER_C_H__
#define PTC_CONVERTER_C_H__

#include "BaseConverter.h"

class Converter_C : public BaseConverter {
public:
  Converter_C();

  // Conversion from source to destination available ?
  virtual bool formats(const Format &source,const Format &destination);

  // Set palette
  virtual void palette(const int32 palette[]);

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
                    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
                    int d_width,int d_height,int d_pitch);

private:

  // forward
  struct Field;

  // convert function typedef
  typedef void (*Function)(Converter_C &copy,const void *source,void *destination,
			   unsigned count);

  // utility functions
  void setup(const Format &source,const Format &destination);
  Field field(int32 source,int32 destination);
  void analyse(int32 mask,int &base,int &size);

  Converter_C::Function Converter_C::function(const Format &source,const Format &destination);

protected:

        // utility routines
        static inline int32 read_24(const char8 *source);
        static inline void write_24(char8 *destination,int32 pixel);
            
        // pixel conversion
        static inline void convert_pixel(Converter_C &copy,int32 &pixel);

        // copy conversion
        static void convert_copy(Converter_C &copy,const void *source,
				 void *destination,unsigned count);

        // muhmuh color converters
        static void convert_muhmuh32_direct32_rgb888(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_muhmuh32_direct24_rgb888(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_muhmuh32_direct16_rgb565(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_muhmuh32_direct16_rgb555(Converter_C &copy,const void *source,void *destination,unsigned count);
        
        // direct color to direct color conversion (rgba)
        static void convert_direct32_direct32_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct32_direct24_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct32_direct16_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct32_direct8_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct24_direct32_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct24_direct24_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct24_direct16_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct24_direct8_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct16_direct32_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct16_direct24_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct16_direct16_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct16_direct8_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct8_direct32_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct8_direct24_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct8_direct16_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_direct8_direct8_rgba(Converter_C &copy,const void *source,void *destination,unsigned count);

        // direct color to direct color conversion (rgb)

        // indexed color to direct color conversion
        static void convert_indexed8_direct32(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_indexed8_direct24(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_indexed8_direct16(Converter_C &copy,const void *source,void *destination,unsigned count);
        static void convert_indexed8_direct8(Converter_C &copy,const void *source,void *destination,unsigned count);

    private:

        // field data
        struct Field
        {
            int32 mask;
            int shift;
        };

        // format information
        struct Information
        {
            Field r;
            Field g;
            Field b;
            Field a;
        };

        // palette data        
        void *table;
        int32 buffer[256];
        
        // format data
        Format s_format;
        Format d_format;
        
        // conversion data
        int s_bytes;
        int d_bytes;
        Information info;
        Function convert;
        Function generate;
};

#endif
