#ifndef PTC_BASE_CONVERTER_H__
#define PTC_BASE_CONVERTER_H__

#include "../ptconfig.h"
#include "../Format.h"


#ifndef NO_ASSEMBLER
struct ConverterInfoAsm {
  char *s_pixels;
  int s_width,s_height;
  int s_add;

  char *d_pixels;
  int d_width,d_height;
  int d_add;

  void (*conv_func)(void);
};
#endif

class BaseConverter {

public:
  // Conversion from source to destination available ?
  virtual bool formats(const Format &source,const Format &destination) = 0;

  // Set palette
  virtual void palette(const int32 palette[]) = 0;

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		    int d_width,int d_height,int d_pitch) = 0;
};

#endif


