//
// RNI Timer class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.rni;

// class imports
import ptc.Error;



public class Timer implements ptc.base.Timer
{
    public Timer() throws Error
    {
        // create
        create();
    }

    public Timer(double time) throws Error
    {
        // create
        create();

        // set time
        set(time);
    }

    protected void finalize() throws Error
    {
        // destroy
        destroy();
    }
    
    // native methods
    private native void create() throws Error;
    private native void destroy() throws Error;
    public native void set(double time) throws Error;
    public native void start() throws Error;
    public native void stop() throws Error;
    public native double time() throws Error;
    public native double delta() throws Error;
    public native double resolution() throws Error;
}
