//
// JNI Clear class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.jni;

// class imports
import ptc.Error;
import ptc.Color;
import ptc.Format;



public class Clear implements ptc.base.Clear
{
    public Clear() throws Error
    {
        // create
        create();
    }
    
    protected void finalize() throws Error
    {
        // destroy
        destroy();
    }

    // native methods
    private native void create() throws Error;
    private native void destroy() throws Error;
    public native void request(Format format) throws Error;
    public native void clear(Object pixels,int x,int y,int width,int height,int pitch,Color color) throws Error;
}
