//
// Core Format implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include "Format.h"
#include "ptconfig.h"



Format::Format()
{
    // defaults
    m_bits = 0;
    m_r = 0;
    m_g = 0;
    m_b = 0;
    m_a = 0;
    m_direct = false;
    m_indexed = false;
}


Format::Format(int bits)
{
    // indexed color
    m_bits = bits;
    m_r = 0;
    m_g = 0;
    m_b = 0;
    m_a = 0;
    m_direct = false;
    m_indexed = true;
}


Format::Format(int bits,int32 r,int32 g,int32 b,int32 a)
{
    // direct color
    m_bits = bits;
    m_r = r;
    m_g = g;
    m_b = b;
    m_a = a;
    m_direct = true;
    m_indexed = false;
}


Format::Format(const Format &other)
{
    // copy constructor
    *this = other;
}




int32 Format::r() const
{
    // get r
    return m_r;
}


int32 Format::g() const
{
    // get g
    return m_g;
}


int32 Format::b() const
{
    // get b
    return m_b;
}


int32 Format::a() const
{
    // get a
    return m_a;
}


int Format::bits() const
{
    // get bits
    return m_bits;
}


int Format::bytes() const
{ 
    return m_bits>>3;
}


bool Format::direct() const
{
    // get direct
    return m_direct;
}


bool Format::indexed() const
{
    // get indexed
    return m_indexed;
}




Format& Format::operator =(Format const &other)
{
    // assignment
    m_bits = other.bits();
    m_r = other.r();
    m_g = other.g();
    m_b = other.b();
    m_a = other.a();
    m_direct = other.direct();
    m_indexed = other.indexed();
    return *this;
}


bool Format::operator ==(Format const &other) const
{
    // equal to
    if (m_direct && other.direct())
    {
        // direct color
        if (m_bits==other.bits() && 
            m_r==other.r() && 
            m_g==other.g() && 
            m_b==other.b() && 
            m_a==other.a()) return true;
    }
    else if (m_indexed && other.indexed())
    {
        // indexed color
        if (m_bits==other.bits()) return true;
    }

    // failure
    return false;
}


bool Format::operator !=(Format const &other) const
{
    // not equal to
    return !(*this==other);
}








