//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include "Copy.h"
#include "Hermes/Hermes.h"
#include "Error.h"



Copy::Copy()
{ HermesInit();
}


Copy::~Copy()
{ HermesClose();  
}



void Copy::request(const Format &source,const Format &destination,
  const bool stretch)
{
  static HermesFormat a_s,a_d;
  static char a_stretch=stretch?1:0;

  convertformat(source,&a_s);
  convertformat(destination,&a_d);
  
  if(!HermesRequest(&a_s,&a_d,a_stretch))
  throw Error("Requested format conversion not available");
}


void Copy::palette(const int32 palette[])
{ HermesPalette((int32 *)palette);
}


void Copy::copy(const void *s_pixels,int s_x,int s_y,int s_width,
  int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
  int d_height,int d_pitch)
{ HermesCopy(const_cast<void *>(s_pixels),s_x,s_y,s_width,s_height,s_pitch,
	    d_pixels,d_x,d_y,d_width,d_height,d_pitch);
}


void Copy::convertformat(const Format& source,HermesFormat *dest)
{ dest->bpp=source.bits();
  dest->mask_r=source.r();
  dest->mask_g=source.g();
  dest->mask_b=source.b();
  dest->indexed=source.direct()?0:1;
}










