//
// X11 Console implementation for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions 
//


#ifndef __PTC_CONSOLE_H
#define __PTC_CONSOLE_H

// include files
#include <X11/Xlib.h>

#include "Base.h"
#include "X11Display.h"
#include "Area.h"

enum {
  PTC_X11_NODGA = 1,
  PTC_X11_LEAVE_DISPLAY = 2,
  PTC_X11_LEAVE_WINDOW = 4,
  PTC_X11_PEDANTIC_DGA = 8
};

class Console : public BaseConsole
{
    public:
        
        // setup
        Console();
        ~Console();

        // open routines, pick and mix :)
	virtual void open(const char title[],const Format& format);
	virtual void open(const char title[],int width,int height,
			  const Format& format)
	{ open(title,width,height,format,0);
	}
        void open(const char title[],int width,int height,const Format& format,
		  long flags);
	void open(Display *disp,int screen,Window w,const Format& format,
		  long flags=0);
	void open(Display *disp,int screen,Window window,const Format& format,
		  int x,int y,int w,int h,long flags=0);

        virtual void close();


        // synchronization
        virtual void update() { x11disp->update(); }
	virtual void update(const Area &area) { x11disp->update(area); }

        // input
        virtual bool key() { return x11disp->key(); }
        virtual int read() { return x11disp->read(); }

        // copy
        virtual void copy(BaseSurface &surface);
	virtual void copy(BaseSurface &surface,const Area &source,
			  const Area &destination);

        // memory
        virtual void* lock() { return x11disp->lock(); }
        virtual void unlock() { x11disp->unlock(); }


        // load pixels to console
        virtual void load(const void *pixels,int width,int height,
			  const Format &format,const int32 palette[]);
        virtual void load(const void *pixels,int width,int height,
			  const Area &source,const Area &destination,
			  const Format &format,const int32 palette[]);

        // save console pixels
        virtual void save(void *pixels,int width,int height,
			  const Format &format,const int32 palette[]);
        virtual void save(void *pixels,int width,int height,
			  const Area &source,const Area &destination,
			  const Format &format,const int32 palette[]);

        // palette
        virtual void palette(int32 palette[]) { x11disp->palette(palette); }
        virtual const int32* palette() { return x11disp->palette(); }

        // data access
        virtual int width() const { return x11disp->width(); }
        virtual int height() const { return x11disp->height(); }
        virtual int pitch() const { return x11disp->pitch(); }
        virtual const Format& format() const { return x11disp->format(); }
        virtual const char* name() const;


        // --- functions specific to the x11 implementation ---

	// set console X11 flags
	void flags(long mask) { x11disp->flags(mask); }

	// check if we are in windowed mode
	bool isWindow() const;

	// return the display we are using
        Display *getX11Display() const { return x11disp->getX11Display(); }

	// return the screen we are using
	int getX11Screen() const { return x11disp->getX11Screen(); }

	// return the window we are using (0, if in DGA mode) 
	Window getX11Window() const { return x11disp->getX11Window(); }
        
    private:

	X11Display *x11disp;
};


#endif
