//
// Clip class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Clip.h"
#include "Area.h"




Area Clip::clip(const Area &clip,const Area &area)
{
    // get in coordinates
    int left   = area.left();
    int right  = area.right();
    int top    = area.top();
    int bottom = area.bottom();

    // clip them to the "clip" area
    if (left<clip.left()) left = clip.left();
    if (right>clip.right()) right = clip.right();
    if (top<clip.top()) top = clip.top();
    if (bottom>clip.bottom()) bottom = clip.bottom();

    // return clipped area
    return Area(left,top,right,bottom);
}






