#include "Conv_GC.h"


// TO 32 RGB

void Hermes_GC_muhmu32_32rgb888(char8 *source,char8 *dest,unsigned int count)
{ int32 s_pixel;

  while(count--)
  { s_pixel=READ32(source);

    s_pixel=(s_pixel&0xff)|((s_pixel&(0xff<<10))>>2)|((s_pixel&(0xff<<20))>>4);

    WRITE32(dest,s_pixel);
    
    dest+=4;
    source+=4;
  }
}


// TO 32 BGR

void Hermes_GC_muhmu32_32bgr888(char8 *source,char8 *dest,unsigned int count)
{ int32 s_pixel;

  while(count--)
  { s_pixel=READ32(source);

    s_pixel=((s_pixel&0xff)<<16)|((s_pixel&(0xff<<10))>>2)|
            ((s_pixel&(0xff<<20))>>12);

    WRITE32(dest,s_pixel);

    dest+=4;
    source+=4;
  }
}



// TO 24 RGB

void Hermes_GC_muhmu32_24rgb888(char8 *source,char8 *dest,unsigned int count)
{ int32 s_pixel;
  char8 *s_point=(char8 *)&s_pixel;

  while(count--)
  { s_pixel=READ32(source);
    s_pixel=(s_pixel&0xff)|((s_pixel&(0xff<<10))>>2)|((s_pixel&(0xff<<20))>>4);

    *(dest+R_24)=*(s_point+R_32);
    *(dest+G_24)=*(s_point+G_32);
    *(dest+B_24)=*(s_point+B_32);

    source+=4;
    dest+=3;
  }
}


// TO 24 BGR

void Hermes_GC_muhmu32_24bgr888(char8 *source,char8 *dest,unsigned int count)
{ int32 s_pixel;
  char8 *s_point=(char8 *)&s_pixel;

  while(count--)
  { s_pixel=READ32(source);
    s_pixel=(s_pixel&0xff)|((s_pixel&(0xff<<10))>>2)|((s_pixel&(0xff<<20))>>4);
 
    // Note that R and B are swapped
    *(dest+B_24)=*(s_point+R_32);
    *(dest+G_24)=*(s_point+G_32);
    *(dest+R_24)=*(s_point+B_32);

    source+=4;
    dest+=3;
  }
}


// TO 16 RGB 565

void Hermes_GC_muhmu32_16rgb565(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  int32 r,g,b;
  int32 s_pixel,d_pixelblock;
  short16 d_pixel;

  // If the current pixel isn't dword aligned, try write one pixel first

  if(((int)dest&0x3)!=0)
  { s_pixel=READ32(source);
  
    r=(s_pixel>>12)&0xf800;
    g=(s_pixel>>7)&0x7e0;
    b=(s_pixel>>3)&0x1f;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);

    source+=4; 
    dest+=2;
    count--;
  }

  // Write blocks of two pixels
  
  for(i=0;i<count>>1;i++,source+=8, dest+=4)
  { s_pixel=READ32(source);
     
    d_pixelblock=((s_pixel>>12)&0xf800)|
                 ((s_pixel>>7)&0x7e0)|
                 ((s_pixel>>3)&0x1f);

    s_pixel=READ32(source+1);
     
    d_pixelblock|=(((s_pixel>>12)&0xf800)|
                  ((s_pixel>>7)&0x7e0)|
                  ((s_pixel>>3)&0x1f))<<16;
   
    WRITE32(dest,d_pixelblock);
  }


  // Eventually, write a single odd pixel that might be left

  if(count&1)
  { s_pixel=READ32(source);
    s_pixel=(s_pixel&0xff)|((s_pixel&(0xff<<10))>>2)|((s_pixel&(0xff<<20))>>4);
 
    r=(s_pixel>>12)&0xf800;
    g=(s_pixel>>7)&0x7e0;
    b=(s_pixel>>3)&0x1f;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);
  }
}


// TO 16 BGR 565

void Hermes_GC_muhmu32_16bgr565(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  int32 r,g,b;
  int32 s_pixel,d_pixelblock;
  short16 d_pixel;

  // If the current pixel isn't dword aligned, try write one pixel first

  if(((int)dest&0x3)!=0)
  { s_pixel=READ32(source);
 
    r=(s_pixel>>23)&0x1f;
    g=(s_pixel>>7)&0x7e0;
    b=(s_pixel<<8)&0xf800;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);

    source+=4; 
    dest+=2;
    count--;
  }

  // Write blocks of two pixels
  
  for(i=0;i<count>>1;i++,source+=8, dest+=4)
  { s_pixel=READ32(source);

    d_pixelblock=((s_pixel>>23)&0x1f)|
                 ((s_pixel>>7)&0x7e0)|
                 ((s_pixel<<8)&0xf800);

    s_pixel=READ32(source+1);

    d_pixelblock|=(((s_pixel>>23)&0x1f)|
                  ((s_pixel>>7)&0x7e0)|
                  ((s_pixel<<8)&0xf800))<<16;
   
    WRITE32(dest,d_pixelblock);
  }


  // Eventually, write a single odd pixel that might be left

  if(count&1)
  { s_pixel=READ32(source);

    r=(s_pixel>>23)&0x1f;
    g=(s_pixel>>7)&0x7e0;
    b=(s_pixel<<8)&0xf800;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);
  }
}


// TO 16 RGB 555


void Hermes_GC_muhmu32_16rgb555(char8 *source,char8 *dest,unsigned int count)
{ int32 r,g,b;
  int32 s_pixel,d_pixelblock;
  short16 d_pixel;
  unsigned int i;


  if(((int)dest&0x3)!=0)
  { s_pixel=READ32(source);
 
    r=(s_pixel>>13)&0x7c00;
    g=(s_pixel>>8)&0x3e0;
    b=(s_pixel>>3)&0x1f;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);

    source+=4; 
    dest+=2;
    count--;
  }

  for(i=0;i<count>>1;i++,source+=8,dest+=4)
  { s_pixel=READ32(source);

    d_pixelblock=((s_pixel>>13)&0x7c00)|
                 ((s_pixel>>8)&0x3e0)|
                 ((s_pixel>>3)&0x1f);

    s_pixel=READ32(source+1);

    d_pixelblock|=(((s_pixel>>13)&0x7c00)|
                  ((s_pixel>>8)&0x3e0)|
                  ((s_pixel>>3)&0x1f))<<16;
   
    WRITE32(dest,d_pixelblock);
  }

  if(count&1)
  { s_pixel=READ32(source);

    r=(s_pixel>>13)&0x7c00;
    g=(s_pixel>>8)&0x3e0;
    b=(s_pixel>>3)&0x1f;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);
  }
}



// TO 16 BGR 555

void Hermes_GC_muhmu32_16bgr555(char8 *source,char8 *dest,unsigned int count)
{ int32 r,g,b;
  int32 s_pixel,d_pixelblock;
  short16 d_pixel;
  unsigned int i;


  if(((int)dest&0x3)!=0)
  { s_pixel=READ32(source);
 
    r=(s_pixel>>23)&0x1f;
    g=(s_pixel>>8)&0x3e0;
    b=(s_pixel<<7)&0x7c00;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);

    source+=4; 
    dest+=2;
    count--;
  }

  for(i=0;i<count>>1;i++,source+=8,dest+=4)
  { s_pixel=READ32(source);

    d_pixelblock=((s_pixel>>23)&0x1f)|
                 ((s_pixel>>8)&0x3e0)|
                 ((s_pixel<<7)&0x7c00);

    s_pixel=READ32(source+1);

    d_pixelblock|=(((s_pixel>>19)&0x1f)|
                  ((s_pixel>>6)&0x3e0)|
                  ((s_pixel<<7)&0x7c00))<<16;
   
    WRITE32(dest,d_pixelblock);
  }

  if(count&1)
  { s_pixel=READ32(source);

    r=(s_pixel>>23)&0x1f;
    g=(s_pixel>>8)&0x3e0;
    b=(s_pixel<<7)&0x7c00;

    d_pixel=(short16)(r|g|b);

    WRITE16(dest,d_pixel);
  }
}



// TO 8 RGB 332

void Hermes_GC_muhmu32_8rgb332(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  int32 s_pixel,d_block;
  char8 d_pixel;

  // Process single pixels until we are dword aligned

  while(count && ((int)dest&0x3)!=0)
  { s_pixel=READ32(source);

    d_pixel=((s_pixel>>20)&0xe0)|
            ((s_pixel>>13)&0x1c)|
            ((s_pixel>>6)&0x3);

    *(dest)=d_pixel;

    count--;
    dest++;
    source+=4;
  }  


  // Now process blocks of four pixels

  for(i=0;i<count>>2;i++,source+=16,dest+=4)
  { s_pixel=READ32(source);
    d_block=((s_pixel>>20)&0xe0)|((s_pixel>>13)&0x1c)|((s_pixel>>6)&0x3);

    s_pixel=READ32(source+1);
    d_block|=(((s_pixel>>20)&0xe0)|((s_pixel>>13)&0x1c)|((s_pixel>>6)&0x3))<<8;
    
    s_pixel=READ32(source+2);
    d_block|=(((s_pixel>>20)&0xe0)|((s_pixel>>13)&0x1c)|((s_pixel>>6)&0x3))<<16;
   
    s_pixel=READ32(source+3);
    d_block|=(((s_pixel>>20)&0xe0)|((s_pixel>>13)&0x1c)|((s_pixel>>6)&0x3))<<24;

    WRITE32(dest,d_block);
  }

  // Write a possibly remaining pixel
 
  if(count&1)
  { s_pixel=READ32(source);

    d_pixel=((s_pixel>>20)&0xe0)|
            ((s_pixel>>13)&0x1c)|
            ((s_pixel>>6)&0x3);

    *(dest)=d_pixel;
  }  
}



// GENERIC (slow) routines from 32 bit rgb to *. Note that these routines will
// hopefully NEVER be called as all cases should be catered for by special
// routines

void Hermes_GC_muhmu32_Generic32(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  int32 s_pixel,r,g,b;

  for(i=0;i<count;i++, source+=4, dest+=4)
  { s_pixel=READ32(source);

    r=((s_pixel>>Hermes_GC_GI.r_right)<<Hermes_GC_GI.r_left)&
      Hermes_Generic_C.m_dest->mask_r;
    g=((s_pixel>>Hermes_GC_GI.g_right)<<Hermes_GC_GI.g_left)&
      Hermes_Generic_C.m_dest->mask_g;
    b=((s_pixel>>Hermes_GC_GI.b_right)<<Hermes_GC_GI.b_left)&
      Hermes_Generic_C.m_dest->mask_b;
    
    WRITE32(dest,(r|g|b));    
  }
}


void Hermes_GC_muhmu32_Generic16(char8 *source,char8 *dest,unsigned int count)
{ unsigned int i;
  int32 s_pixel,r,g,b;
  int32 d_block;

  // This is a slower routine, but we will still write dwords, not words

  for(i=0;i<count>>1;i++,source+=8, dest+=4)
  { s_pixel=READ32(source);
  
    r=((s_pixel>>Hermes_GC_GI.r_right)<<Hermes_GC_GI.r_left)&
      Hermes_Generic_C.m_dest->mask_r;
    g=((s_pixel>>Hermes_GC_GI.g_right)<<Hermes_GC_GI.g_left)&
      Hermes_Generic_C.m_dest->mask_g;
    b=((s_pixel>>Hermes_GC_GI.b_right)<<Hermes_GC_GI.b_left)&
      Hermes_Generic_C.m_dest->mask_b;
    d_block=(int32)(r|g|b);

    s_pixel=READ32(source+1);

    r=((s_pixel>>Hermes_GC_GI.r_right)<<Hermes_GC_GI.r_left)&
      Hermes_Generic_C.m_dest->mask_r;
    g=((s_pixel>>Hermes_GC_GI.g_right)<<Hermes_GC_GI.g_left)&
      Hermes_Generic_C.m_dest->mask_g;
    b=((s_pixel>>Hermes_GC_GI.b_right)<<Hermes_GC_GI.b_left)&
      Hermes_Generic_C.m_dest->mask_b;
    d_block=d_block|((int32)(r|g|b)<<16);

    WRITE32(dest,d_block);
  }

  if(count&1)
  { s_pixel=READ32(source);
  
    r=((s_pixel>>Hermes_GC_GI.r_right)<<Hermes_GC_GI.r_left)&
      Hermes_Generic_C.m_dest->mask_r;
    g=((s_pixel>>Hermes_GC_GI.g_right)<<Hermes_GC_GI.g_left)&
      Hermes_Generic_C.m_dest->mask_g;
    b=((s_pixel>>Hermes_GC_GI.b_right)<<Hermes_GC_GI.b_left)&
      Hermes_Generic_C.m_dest->mask_b;

    WRITE16(dest,(short16)(r|g|b));
  }
}


