//
// MMX converter header for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __HERMES_CONV_MMX_H__
#define __HERMES_CONV_MMX_H__

#include <stdlib.h>
#include "Base.h"


#ifdef NO_ASSEMBLER

void Hermes_MMX_init() { }
void Hermes_MMX_close() { }
char Hermes_MMX_request(HermesFormat *source,HermesFormat *dest,char stretch)
{ return 0; }
void Hermes_MMX_palette(int32 *palette) { }
void Hermes_MMX_copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
		    int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
		    int d_height,int d_pitch) { }
#else

void Hermes_MMX_init();
void Hermes_MMX_close();
char Hermes_MMX_request(HermesFormat *source,HermesFormat *dest,char stretch);
void Hermes_MMX_palette(int32 *palette);
void Hermes_MMX_copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
		    int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
		    int d_height,int d_pitch);

#endif   // NO_ASSEMBLER


static BaseConverter Hermes_MMX=
{ NULL, 
  NULL,
  0,
  Hermes_MMX_init,
  Hermes_MMX_close,
  Hermes_MMX_request,
  Hermes_MMX_palette,
  Hermes_MMX_copy
};

#endif

