/*
 * TextFX2 Copyright (c) 1998 Jari Komppa aka Sol/Trauma
 * <mailto:solar@compart.fi>
 *
 * Textmode low-level functions
 *
 * This sourcefile is kinda long-ish, and should be split into several
 * sources, but I have wanted to keep it in one file since everything
 * here is kinda small and.. well, I wanted to keep it as a single .obj
 * file.
 *
 * If you make improvements, send me a copy!
 * If you use this for something, let me know!
 */

#ifndef __TEXTFX2_H_
#define __TEXTFX2_H_

#ifdef __cplusplus
extern "C" {
#endif

/*************************************************************************
 * Global data & variables
 *
 */

extern char palette[];

/*
 * Charsets in 'lightness' order. First byte = num of chars
 *
 * Please note that these don't work with the current calcpal
 * strategy :)
 *
 */

extern char charset_b8ibm[]; /* all imbscii characters */
extern char charset_b7asc[]; /* 7b ascii (chars 32 - 126) */
extern char charset_b7sml[]; /* " crsxzvenaouwm" dark->light. */
extern char charset_b8gry[]; /* 8b ibm grayscale characters */
extern char charset_b7nws[]; /* 7b grayscale 'newschool' askee chars*/
extern char * use_charset;   /* Character set to use. Can be changed run-time. */
extern short int * colmap;

/*************************************************************************
 * Prototypes
 *
 */

extern void set80x43(void); /* Sets up 80x43, no blink, no cursor. */
extern void set80x50(void); /* Sets up 80x50, no blink, no cursor. */
extern void set80x25(void); /* Resets 80x25, blink, cursor. */
extern void border(char color); /* _ONLY_ for debugging! */
extern void vrc(void); /* Although all should be timer-synced instead.. */

/*
 * calc_ functions are pretty *S*L*O*W* so use them to precalculate
 * color tables and then use those tables instead.
 */

extern short int calcpal_colorbase(float red, float green, float blue);
extern short int calcpal_lightbase(float red, float green, float blue);
extern short int calcpal_lightbase_g(float red, float green, float blue);
extern short int (*calcpal)(float red, float green, float blue);
    /* Finds the closest color/char combo for any 0:63,0:63,0:63 value.
     *
     * calcpal_colorbase is the 'old' calcpal, only "a bit" optimized.
     * calcpal is now function pointer so calcpal function can be changed
     * run-time. Use the functions directly if you need speed (and
     * compile with -oe256 or something to force inlining)
     */

extern short int calc_gscale(float light);
extern short int calc_gscale2(float light);
    /* Finds the closes gscale color/char combo for 0..1 range
     * gscale2 uses colors 8,7,15, normal just uses 7.
     */

extern void build_colormap(int dots);
    /* Used to calculate colormap for dump_nnx() -functions.
     * if dots=0, will output nothing.
     *         1, will cprintf .:s as process.
     *         2, will cprintf rolling wheel as process.
     */

extern void dump_80x(int y0, int y1, int * buffer);
    /* Dumps 80-pixel wide 0bgr-truecolor buffer from y0 to y1.
     * (For fullscreen dump in 80x43 use dump_80x(0,43,buf);
     */

extern void dump_160x(int y0, int y1, int * buffer);
    /* Dumps 160-pixel wide 0bgr-truecolor buffer from y0 to y1
     * with 4-to-1 pixel averaging.
     */

extern void dump_320x(int y0, int y1, int * buffer);
    /* Dumps 160-pixel wide 0bgr-truecolor buffer from y0 to y1
     * with 16-to-1 pixel averaging. (this is tad bit slow :)
     */

/*************************************************************************
 * Defines
 *
 */

#define putpixel_textmode(x,y,c) *(short int *)(0xb8000+(x)*2+(y)*160)=(c);


#ifdef __cplusplus
}
#endif

#endif
