#ifndef __HERMES_FORMAT__
#define __HERMES_FORMAT__


#include "Types.h"


typedef struct {
  int32 r,g,b,a;                   /* Bitmasks for red, green, blue, alpha */
  int bits;                        /* Bits per pixel */
  char indexed;                    /* 1 if indexed colour format */
} HermesFormat;


/* Create a new empty format structure */
HermesFormat *Hermes_FormatNewEmpty();


/* Create a new format structure, returns 0 if failed */
HermesFormat *Hermes_FormatNew(int bits,int32 r,int32 g,int32 b,int32 a,
			       char indexed);


/* Compare two formats. Return 1 if they are equal, 0 otherwise */
char Hermes_FormatEquals(HermesFormat *op1,HermesFormat *op2);


void Hermes_FormatCopy(HermesFormat *source,HermesFormat *dest);



#endif

