//
// Keyboard class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_DOS_KEYBOARD_H
#define __PTC_DOS_KEYBOARD_H

// include files
#include "Core/Key.h"
#include "Core/Config.h"




class DosKeyboard
{
    public:

        // setup
        DosKeyboard();//HWND window,DWORD thread,bool multithreaded);
        ~DosKeyboard();

        // input
        bool key();
        Key read();//Win32Window &window);

    private:


        // internal key functions
        void insert(const Key &key);
        Key remove();
        bool ready();

        // data
        bool m_key;

        // modifiers
        bool m_alt;
        bool m_shift;
        bool m_control;

        // key buffer
        int m_head;
        int m_tail;
        Key m_buffer[1024];
};




#endif
