//
// Palette class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <string.h>
#include "Error.h"
#include "Config.h"
#include "Palette.h"




Palette::Palette()
{
    // clear locked flag
    m_locked = false;

    // clear palette
    memset(m_data,0,1024);
}


Palette::Palette(const int32 data[])
{
    // clear locked flag
    m_locked = false;

    // load data
    load(data);
}


Palette::Palette(const Palette &palette)
{
    // clear locked flag
    m_locked = false;

    // assignment
    *this = palette;
}


Palette::~Palette()
{
    // check if palette is locked
    if (m_locked) throw Error("palette is still locked");
}




int32* Palette::lock()
{
    // check locked flag
    if (m_locked) throw Error("palette is already locked");

    // set locked flag
    m_locked = true;

    // lock palette
    return m_data;
}


void Palette::unlock()
{
    // check locked flag
    if (!m_locked) throw Error("palette is not locked");

    // reset locked flag
    m_locked = false;
}




void Palette::load(const int32 data[])
{
    #ifdef __DEBUG__

        // check for null data pointer
        if (!data) throw Error("null data pointer in palette load");

    #else
    
        // no checking is performed in release build

    #endif
    
    // load palette data
    memcpy(m_data,data,1024);
}




void Palette::save(int32 data[]) const
{
    #ifdef __DEBUG__

        // check for null data pointer
        if (!data) throw Error("null data pointer in palette save");

    #else
    
        // no checking is performed in release build

    #endif
    
    // save palette data
    memcpy(data,m_data,1024);
}




const int32* Palette::data() const
{
    // get palette data
    return m_data;
}




Palette& Palette::operator =(const Palette &palette)
{
    // check for self assignment
    if (this==&palette) throw Error("self assignment is not allowed");
        
    // assignment
    memcpy(m_data,palette.m_data,1024);
    return *this;
}


bool Palette::operator ==(const Palette &palette) const
{
    // is equal to
    if (memcmp(m_data,palette.m_data,1024)==0) return true;
    else return false;
}


bool Palette::operator !=(const Palette &palette) const
{
    // not equal to
    return !(*this==palette);
}
