//
// Area class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_AREA_H
#define __PTC_AREA_H

// include files
#include "Types.h"




class Area
{
    public:

        // setup
        Area();
        Area(int left,int top,int right,int bottom);
        Area(const Area &area);
        ~Area();

        // data access
        int left()   const;
        int right()  const;
        int top()    const;
        int bottom() const;
        int width()  const;
        int height() const;

        // operators
        Area& operator =(const Area &area);
        bool operator ==(const Area &area) const;
        bool operator !=(const Area &area) const;

    private:

        // data
        int m_left;
        int m_right;
        int m_top;
        int m_bottom;
};




#endif
