//
// DirectX Hook class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include "Core/Error.h"
#include "DirectX/Hook.h"
#include "DirectX/Display.h"
#include "DirectX/Console.h"




DirectXHook::DirectXHook(DirectXConsole &console,HWND window,DWORD thread,bool cursor) : Win32Hook(window,thread)
{
    // setup display
    m_cursor = cursor;
    m_console = &console;
}

    


LRESULT DirectXHook::WndProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
    switch (message)
    {
        /*
        case WM_DIRECTX_OPEN:
        {
            // setup message data
            DirectXDisplay::Data *data = (DirectXDisplay::Data*)wParam;
            bool *result = (bool*)lParam;
            
            try
            {
                // open display
                data->display->open(hWnd,data->width,data->height,*data->format);

                // success
                *result = true;
            }
            catch (Error&)
            {
                // failure
                *result = false;
            }

            // set event
            data->event.set();

            // handled
            return TRUE;
        }
        break;

        case WM_DIRECTX_CLOSE:
        {
            // setup message data
            DirectXDisplay::Data *data = (DirectXDisplay::Data*)wParam;

            try
            {
                // close display
                if (data->display) data->display->close();
            }
            catch (Error&)
            {
                // no exceptions thanks...
            }

            // set event
            data->event.set();

            // handled
            return TRUE;
        }
        break;
        */

        case WM_ACTIVATEAPP:
        {
            // get window message data
            BOOL active = (BOOL) wParam;
            DWORD thread = (DWORD) lParam;
            
            // check active flag
            if (active==FALSE)
            {
                // deactivate
                deactivate();
            }
            else
            {
                // activate
                activate();
            }

            // handled
            return TRUE;
        }
        break;

        case WM_ACTIVATE:
        {
            // get window message data
            WORD active = LOWORD(wParam);
            BOOL minimized = (BOOL) HIWORD(wParam);
            HWND previous = (HWND) lParam;
            
            // check active flag
            if (active==WA_INACTIVE)
            {
                // deactivate
                deactivate();
            }
            else
            {
                // activate
                activate();
            }

            // handled
            return TRUE;
        }
        break;

        case WM_SETCURSOR:
        {
            // check cursor
            if (!m_cursor)
            {
                // hide cursor
                ShowCursor(0);
            }

            // handled
            return TRUE;
        }
        break;

        case WM_CLOSE:
        {
            // close console
            m_console->close();

            // handled
            return TRUE;
        }
        break;
    }

    // unhandled
    return FALSE;
}




void DirectXHook::activate()
{
    // get console object references
    DirectXDisplay &display = m_console->m_display;
    DirectXPrimary &primary = m_console->m_primary;

    // check if primary is not active
    if (!primary.active())
    {
        // save display
        display.save();

        // activate primary
        primary.activate();
    }
}


void DirectXHook::deactivate()
{
    // get console object references
    DirectXDisplay &display = m_console->m_display;
    DirectXPrimary &primary = m_console->m_primary;

    // check if primary is active
    if (primary.active())
    {
        // save primary
        primary.save();

        // deactivate primary
        primary.deactivate();

        // restore display
        display.restore();
    }
}
