//
// JNI Console class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.jni;

// import classes
import ptc.Key;
import ptc.Area;
import ptc.Mode;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public class Console implements ptc.base.Console
{
    public Console() throws Error
    {
        // register console
        Error.register(this);

        // create
        create();
    }

    protected void finalize() throws Error
    {
        // unregister console
        Error.unregister(this);

        // close
        close();
        
        // destroy
        destroy();
    }

    // native methods
    private native void create() throws Error;
    private native void destroy() throws Error;
    public native void configure(String file) throws Error;
    public native boolean option(String option) throws Error;
    public native Mode[] modes() throws Error;
    public native void open(String title) throws Error;
    public native void open(String title,int pages) throws Error;
    public native void open(String title,Format format) throws Error;
    public native void open(String title,Format format,int pages) throws Error;
    public native void open(String title,int width,int height,Format format) throws Error;
    public native void open(String title,int width,int height,Format format,int pages) throws Error;
    public native void open(String title,Mode mode) throws Error;
    public native void open(String title,Mode mode,int pages) throws Error;
    public native void close() throws Error;
    public native void flush() throws Error;
    public native void finish() throws Error;
    public native void update() throws Error;
    public native void update(Area area) throws Error;
    public native boolean key() throws Error;
    public native Key read() throws Error;
    public native void copy(ptc.base.Surface surface) throws Error;
    public native void copy(ptc.base.Surface surface,Area source,Area destination) throws Error;
    public native Object lock() throws Error;
    public native void unlock() throws Error;
    public native void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    public native void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;
    public native void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    public native void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;
    public native void clear() throws Error;
    public native void clear(Color color) throws Error;
    public native void clear(Color color,Area area) throws Error;
    public native void palette(Palette palette) throws Error;
    public native Palette palette() throws Error;
    public native void clip(Area area) throws Error;
    public native int width() throws Error;
    public native int height() throws Error;
    public native int pages() throws Error;
    public native int pitch() throws Error;
    public native Area area() throws Error;
    public native Area clip() throws Error;
    public native Format format() throws Error;
    public native String name() throws Error;
    public native String title() throws Error;
    public native String information() throws Error;
}
