//
// Clear example for OpenPTC 1.0 Java Implementation
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is in the public domain
//

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Surface;
import ptc.Console;



class Clear
{
    public static void main(String argv[])
    {
        try
        {
            // create console
            Console console = new Console();
        
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);
 
            // open the console
            console.open("Clear example",format);

            // create surface matching console dimensions
            Surface surface = new Surface(console.width(),console.height(),format);

            // loop until a key is pressed
            while (!console.key())
            {
                // get surface dimensions
                final int width  = surface.width();
                final int height = surface.height();

                // get random position
                final int x = random(width);
                final int y = random(height);
            
                // get random area size
                final int size = random(width/8);

                // setup clear area
                Area area = new Area(x-size,y-size,x+size,y+size);

                // create random color
                Color color = new Color(random(),random(),random());
            
                // clear surface area with color
                surface.clear(color,area);
            
                // copy to console
                surface.copy(console);
            
                // update console
                console.update();
            }
        }
        catch (Error error)
        {
            // report error
            error.report();
        }

        // exit program
        System.exit(0);
    }

    static int random(int number)
    {
        // random number routine
        return (int) ( Math.random() * number );
    }

    static float random()
    {
        // random float routine
        return (float) Math.random();
    }
}

