// JPG file handler
//
// Copyright (c) 1999 Dan Brown (_danbrown_@yahoo.com)
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//
// This is a wrapper for Independant JPEG groups code (libjpg)
//

#ifndef _JPG_HANDLER_H
#define _JPG_HANDLER_H

#ifdef USE_JPG

#include <stdio.h>
extern "C" {
#include <jpeglib.h>
}
#include "ihandler.h"

class JPGHandler : public ImageHandler
{
public:

  // setup
  JPGHandler();
  JPGHandler(char *filename);
  virtual ~JPGHandler();

  // interface
  virtual int info(int32 &width,int32 &height,Format &format,int32 &palette);
  virtual int load(void *image, Palette *palette);
  virtual int save(char *filename, int32 width, int32 height, 
					     Format *format, Palette *palette, void *pixels, 
					     void *params);
  virtual int valid();
private:

  // sets default values
  void Defaults();

  // file stuff
  FILE *m_imagefile;
  char *m_filename;

  // image data
  int32 m_width;
  int32 m_height;
  Format m_format;

  // libjpg variables
  jpeg_decompress_struct cdinfo;
  jpeg_compress_struct ccinfo;
  jpeg_error_mgr jerr;                   // TODO : use our own error handler
  char sig[4];
};

#endif

#endif

