//
// Handler class - base class for individual file handlers
//
// Copyright (c) Dan Brown 1999 (_danbrown_@yahoo.com)
// Based on code by Glenn Fiedler (ptc@gaffer.org)
//
// Part of the Titan 1.1.x image handling library for PTC
// (http://now.at/Titan)
//
// This source code is licensed under the GNU GPL
//

#ifndef _HANDLER_H_
#define _HANDLER_H_

#define TOPDOWN 0
#define BOTTOMUP 1

#include "ptc.h"
#include "../defaults.h"

class ImageHandler
{
public:
  virtual ~ImageHandler() {};

  virtual int info(int32 &width,int32 &height,Format &format,int32 &palette) = 0;
  virtual int load(void *image, Palette *palette) = 0;
  virtual int save(char *filename, int32 width, int32 height, 
					     Format *format, Palette *palette, void *pixels, 
					     void *params) = 0;
  virtual int valid() = 0;
};

#endif
